/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */

#ifndef	ucd_mem_map_model_H_
#define	ucd_mem_map_model_H_

#undef MEM_MAP_SUB
#define MEM_MAP_SUB(sym)                                              \
	static struct mem_map_sub ucd_mem_map_model_ ## sym[]                 

MEM_MAP_SUB(RLE1                                    ) = {{0x59500000, 0x00002E00}};
MEM_MAP_SUB(RLE2                                    ) = {{0x59602000, 0x00001000}};
MEM_MAP_SUB(RLEIOP0                                 ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(RLEIOP1                                 ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(RLEDMAC                                 ) = {{0x59420000, 0x00001000}};
MEM_MAP_SUB(FDMAC                                   ) = {{0x5A000000, 0x00000140}};
MEM_MAP_SUB(SYS                                     ) = {{0x5E000000, 0x0000C000}};
MEM_MAP_SUB(HCM                                     ) = {{0x5E00C000, 0x00004000}};
MEM_MAP_SUB(HSC                                     ) = {{0x5C000000, 0x01000000}};
MEM_MAP_SUB(AIOF                                    ) = {{0x5F006000, 0x00001000}};
MEM_MAP_SUB(IPR                                     ) = {{0x5F001000, 0x00004000}};
MEM_MAP_SUB(VOUT                                    ) = {{0x5F005000, 0x00001000}};
MEM_MAP_SUB(HOSTIOP                                 ) = {{0x5F008000, 0x00000090}};
MEM_MAP_SUB(HASI                                    ) = {{0x5F00E000, 0x00001000}};
MEM_MAP_SUB(LOSD                                    ) = {{0x5F028000, 0x00001000}};
MEM_MAP_SUB(AVCORE                                  ) = {{0x5F800000, 0x00002000}};
MEM_MAP_SUB(SOCGLUE                                 ) = {{0x5F900000, 0x00002000}};
MEM_MAP_SUB(DDR_DDR_CH0                             ) = {{0x00000000, 0x08000000}};
MEM_MAP_SUB(DDR_INST_PARAM                          ) = {{0x00010000, 0x00500000}};
MEM_MAP_SUB(DDR_DPPINSTST_0_H264                    ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_HCMDDR_OFFSET                       ) = {{0x00510000, 0x00010000}};
MEM_MAP_SUB(DDR_JPEG_TABLE0                         ) = {{0x014AE000, 0x000048C0}};
MEM_MAP_SUB(DDR_JPEG_HUFFMAN_TABLE0                 ) = {{0x014AE000, 0x00004400}};
MEM_MAP_SUB(DDR_JPEG_Q_TABLE0                       ) = {{0x014B2800, 0x000000C0}};
MEM_MAP_SUB(DDR_JPEG_TABLE1                         ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_HUFFMAN_TABLE1                 ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_Q_TABLE1                       ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_UDLWORK                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SABB0                               ) = {{0x0091F000, 0x00014000}};
MEM_MAP_SUB(DDR_SABB1                               ) = {{0x00933000, 0x00014000}};
MEM_MAP_SUB(DDR_SABB2                               ) = {{0x00947000, 0x00000000}};
MEM_MAP_SUB(DDR_SAE2B0                              ) = {{0x00947000, 0x00000000}};
MEM_MAP_SUB(DDR_ADB                                 ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ABB0                                ) = {{0x00947000, 0x000C0000}};
MEM_MAP_SUB(DDR_ABB1                                ) = {{0x00A07000, 0x00019000}};
MEM_MAP_SUB(DDR_ABB2                                ) = {{0x00A20000, 0x00000000}};
MEM_MAP_SUB(DDR_AOB                                 ) = {{0x00A20000, 0x00300000}};
MEM_MAP_SUB(DDR_AOB0                                ) = {{0x00A20000, 0x00180000}};
MEM_MAP_SUB(DDR_AOB1                                ) = {{0x00BA0000, 0x00180000}};
MEM_MAP_SUB(DDR_AOB2                                ) = {{0x00D20000, 0x00000000}};
MEM_MAP_SUB(DDR_AIB                                 ) = {{0x00D28800, 0x00000000}};
MEM_MAP_SUB(DDR_AIB0                                ) = {{0x00D28800, 0x00000000}};
MEM_MAP_SUB(DDR_AIB1                                ) = {{0x00D28800, 0x00000800}};
MEM_MAP_SUB(DDR_REMASTER0                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_REMASTER1                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_HBASSPARAM0                         ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_HBASSPARAM1                         ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PCMMIX0                             ) = {{0x00D29000, 0x00003000}};
MEM_MAP_SUB(DDR_PCMMIX1                             ) = {{0x00D2C000, 0x00003000}};
MEM_MAP_SUB(DDR_PCMMIX2                             ) = {{0x00D2F000, 0x00000000}};
MEM_MAP_SUB(DDR_BRFILTERCOEF0                       ) = {{0x00D2F000, 0x00000C00}};
MEM_MAP_SUB(DDR_BRFILTERCOEF1                       ) = {{0x00D2FC00, 0x00000C00}};
MEM_MAP_SUB(DDR_BRFILTERCOEF2                       ) = {{0x00D30800, 0x00000800}};
MEM_MAP_SUB(DDR_AUDMIXM2A                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AUDMIXM2B                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AUDMIXM2C                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AUDMIXM2D                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AUDMIXM2E                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AUDMIXM2F                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AUDMIXM2G                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AUDMIXM2H                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AEB0                                ) = {{0x00D28800, 0x00000000}};
MEM_MAP_SUB(DDR_AEB1                                ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_TRANS_AEB0                          ) = {{0x00D28800, 0x00000000}};
MEM_MAP_SUB(DDR_TRANS_AEB1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SIT_AND_PMT0                        ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SIT_AND_PMT1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_APTS_TABLE_DEC                      ) = {{0x00D20000, 0x00004000}};
MEM_MAP_SUB(DDR_APTS_TABLE_DEC0                     ) = {{0x00D20000, 0x00002000}};
MEM_MAP_SUB(DDR_APTS_TABLE_DEC1                     ) = {{0x00D22000, 0x00002000}};
MEM_MAP_SUB(DDR_APTS_TABLE_DEC2                     ) = {{0x00D24000, 0x00000000}};
MEM_MAP_SUB(DDR_RMAACFRM0                           ) = {{0x00D24000, 0x00002000}};
MEM_MAP_SUB(DDR_RMAACFRM1                           ) = {{0x00D26000, 0x00002000}};
MEM_MAP_SUB(DDR_RMAACFRM2                           ) = {{0x00D28000, 0x00000000}};
MEM_MAP_SUB(DDR_ADECINF0                            ) = {{0x00D28000, 0x00000400}};
MEM_MAP_SUB(DDR_ADECINF1                            ) = {{0x00D28400, 0x00000400}};
MEM_MAP_SUB(DDR_ADECINF2                            ) = {{0x00D28800, 0x00000000}};
MEM_MAP_SUB(DDR_APTS_TABLE0                         ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_APTS_TABLE1                         ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SDCARD                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AE1B0                               ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_AE2B0                               ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_CEB0                                ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_AE1PTS_TABLE0                       ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_AE2PTS_TABLE0                       ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_CEPTS_TABLE0                        ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_FCARDADDR                           ) = {{0x41800000, 0x000D8000}};
MEM_MAP_SUB(DDR_COEF                                ) = {{0x0091D000, 0x00000400}};
MEM_MAP_SUB(DDR_FCCOEF                              ) = {{0x0091D400, 0x00001C00}};
MEM_MAP_SUB(DDR_TELETEXT                            ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MNIP_Y                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MNIP_C                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MVR_Y0                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MVR_Y1                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MVR_Y2                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MVR_Y3                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MVR_C0                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MVR_C1                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MVR_C2                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_MVR_C3                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SVR0                                ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SVR1                                ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SVR2                                ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SVR3                                ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FILTER2_IPCONV                      ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FILTER1Y                            ) = {{0x41C00000, 0x001FE000}};
MEM_MAP_SUB(DDR_FILTER1C                            ) = {{0x41DFE000, 0x000FF000}};
MEM_MAP_SUB(DDR_FILTER2Y                            ) = {{0x41EFD000, 0x00000000}};
MEM_MAP_SUB(DDR_FILTER2C                            ) = {{0x41EFD000, 0x00001000}};
MEM_MAP_SUB(DDR_FILTEREXIVY                         ) = {{0x4039A000, 0x00BDD800}};
MEM_MAP_SUB(DDR_FILTEREXIVC                         ) = {{0x40F77800, 0x00000000}};
MEM_MAP_SUB(DDR_FILTER2ND_A                         ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_FILTER2ND_B                         ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_IOSD0_0                             ) = {{0x41EFD000, 0x007E9000}};
MEM_MAP_SUB(DDR_IOSD0_1                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSD0_2                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSD1_0                             ) = {{0x426E6000, 0x00000000}};
MEM_MAP_SUB(DDR_IOSD1_1                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSD1_2                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_CURSOR_0                            ) = {{0x03A81000, 0x00000000}};
MEM_MAP_SUB(DDR_CURSOR_1                            ) = {{0x03A81000, 0x00000000}};
MEM_MAP_SUB(DDR_CLUT0                               ) = {{0x03A81000, 0x00000400}};
MEM_MAP_SUB(DDR_CLUT1                               ) = {{0x03A82000, 0x00000400}};
MEM_MAP_SUB(DDR_CLUT2                               ) = {{0x03A83000, 0x00000400}};
MEM_MAP_SUB(DDR_CLUT3                               ) = {{0x03A84000, 0x00000400}};
MEM_MAP_SUB(DDR_CLUT4                               ) = {{0x03A85000, 0x00000400}};
MEM_MAP_SUB(DDR_CLUT5                               ) = {{0x03A86000, 0x00000400}};
MEM_MAP_SUB(DDR_LOSD0_0                             ) = {{0x03A88000, 0x007EA000}};
MEM_MAP_SUB(DDR_LOSD0_0_L                           ) = {{0x03A88000, 0x007E9000}};
MEM_MAP_SUB(DDR_LOSD0_0_R                           ) = {{0x04271000, 0x00001000}};
MEM_MAP_SUB(DDR_LOSD0_1                             ) = {{0x04272000, 0x007E9000}};
MEM_MAP_SUB(DDR_LOSD0_1_L                           ) = {{0x04272000, 0x007E9000}};
MEM_MAP_SUB(DDR_LOSD0_1_R                           ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD0_2                             ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD0_2_L                           ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD0_2_R                           ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD1_0                             ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD1_0_L                           ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD1_0_R                           ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD1_1                             ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD1_1_L                           ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD1_1_R                           ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD1_2                             ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD1_2_L                           ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_LOSD1_2_R                           ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_VOSD                                ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_DDI_GPU                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_LOSD_BUFFER                         ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_EPG_BUFFER                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AJAX_BUFFER0                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AJAX_BUFFER1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSDB0                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSDB1                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSDC0                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSDC1                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSDD0                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSDD1                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PG                                  ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGCBB                               ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGCBB0                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGCBB1                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGCDBB                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGCDBB0                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGCDBB1                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOBTABLE                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOBTABLE0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOBTABLE0_0                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOBTABLE0_1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOBTABLE1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOBTABLE1_0                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOBTABLE1_1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOB                                ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOB0                               ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGOB1                               ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGPBTABLE                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGPBTABLE0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGPBTABLE0_0                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGPBTABLE0_1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGPBTABLE1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGPBTABLE1_0                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_PGPBTABLE1_1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSDA0                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IOSDA1                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IG                                  ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBB                               ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBB0                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBB0_0                            ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBB0_1                            ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBB1                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBB1_0                            ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBB1_1                            ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCDBB                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCDBB0                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCDBB1                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGOBTABLE                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGOBTABLE0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGOBTABLE0_0                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGOBTABLE0_1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGOBTABLE1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGOBTABLE1_0                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGOBTABLE1_1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGDOB                               ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGDOB0                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGDOB0_0                            ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGDOB0_1                            ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGDOB1                              ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGDOB1_0                            ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGDOB1_1                            ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGPBTABLE                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGPBTABLE0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGPBTABLE0_0                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGPBTABLE0_1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGPBTABLE1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGPBTABLE1_0                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGPBTABLE1_1                        ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBTABLE                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBTABLE0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_IGCBTABLE1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_STILL0_Y0                           ) = {{0x41EFE000, 0x001FE000}};
MEM_MAP_SUB(DDR_STILL0_C0                           ) = {{0x420FC000, 0x000FF000}};
MEM_MAP_SUB(DDR_STILL0_Y1                           ) = {{0x421FC000, 0x001FE000}};
MEM_MAP_SUB(DDR_STILL0_C1                           ) = {{0x423FA000, 0x000FF000}};
MEM_MAP_SUB(DDR_STILL1_Y0                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_STILL1_C0                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_STILL1_Y1                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_STILL1_C1                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_BDJIMGAUD                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_THUMBNAIL                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_RLE                                 ) = {{0x04A5B000, 0x00000000}};
MEM_MAP_SUB(DDR_SPUBB0                              ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SPUBB1                              ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SPU0                                ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SPU1                                ) = {{0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SVBB0                               ) = {{0x00D31000, 0x00008000}, {0x00D31000, 0x00008000}, {0x00D31000, 0x00008000}};
MEM_MAP_SUB(DDR_VBB0                                ) = {{0x00D39000, 0x00752800}, {0x00D39000, 0x001F5000}, {0x00D39000, 0x001F5000}};
MEM_MAP_SUB(DDR_VDB0                                ) = {{0x00F2E000, 0x0055D800}, {0x00F2E000, 0x0055D800}, {0x00F2E000, 0x0055D800}};
MEM_MAP_SUB(DDR_PARAM0                              ) = {{0x0148B800, 0x00020800}, {0x0148B800, 0x00020800}, {0x0148B800, 0x00020800}};
MEM_MAP_SUB(DDR_NONVCLPRM0                          ) = {{0x0148B800, 0x0001B7A0}, {0x0148B800, 0x0001B7A0}, {0x0148B800, 0x0001B7A0}};
MEM_MAP_SUB(DDR_SLHPRM0                             ) = {{0x014A6FA0, 0x00000080}, {0x014A6FA0, 0x00000080}, {0x014A6FA0, 0x00000080}};
MEM_MAP_SUB(DDR_SEIMSG0                             ) = {{0x014A7020, 0x00000800}, {0x014A7020, 0x00000800}, {0x014A7020, 0x00000800}};
MEM_MAP_SUB(DDR_DPBINFOPRM0                         ) = {{0x014A7820, 0x00000200}, {0x014A7820, 0x00000200}, {0x014A7820, 0x00000200}};
MEM_MAP_SUB(DDR_RPLPRM0                             ) = {{0x014A8000, 0x00000190}, {0x014A8000, 0x00000190}, {0x014A8000, 0x00000190}};
MEM_MAP_SUB(DDR_QMTRXPRM0                           ) = {{0x014A8190, 0x00000130}, {0x014A8190, 0x00000130}, {0x014A8190, 0x00000130}};
MEM_MAP_SUB(DDR_DECINFOPRM0                         ) = {{0x014A82C0, 0x00000020}, {0x014A82C0, 0x00000020}, {0x014A82C0, 0x00000020}};
MEM_MAP_SUB(DDR_ACODECPRM0                          ) = {{0x014A9000, 0x00000048}, {0x014A9000, 0x00000048}, {0x014A9000, 0x00000048}};
MEM_MAP_SUB(DDR_MKVPRM0                             ) = {{0x014AA000, 0x00000100}, {0x014AA000, 0x00000100}, {0x014AA000, 0x00000100}};
MEM_MAP_SUB(DDR_MP4PRM0                             ) = {{0x014AB000, 0x00001000}, {0x014AB000, 0x00001000}, {0x014AB000, 0x00001000}};
MEM_MAP_SUB(DDR_SWWORKBUFF0                         ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_SUBSETSPS0                          ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SVBB1                               ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_VBB1                                ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_VDB1                                ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_PARAM1                              ) = {{0x014AC000, 0x00002000}, {0x014AC000, 0x00002000}, {0x014AC000, 0x00002000}};
MEM_MAP_SUB(DDR_NONVCLPRM1                          ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_SLHPRM1                             ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_SEIMSG1                             ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_DPBINFOPRM1                         ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_RPLPRM1                             ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_QMTRXPRM1                           ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_DECINFOPRM1                         ) = {{0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}, {0x014AC000, 0x00000000}};
MEM_MAP_SUB(DDR_ACODECPRM1                          ) = {{0x014AC000, 0x00000048}, {0x014AC000, 0x00000048}, {0x014AC000, 0x00000048}};
MEM_MAP_SUB(DDR_MKVPRM1                             ) = {{0x014AC048, 0x00000FB8}, {0x014AC048, 0x00000FB8}, {0x014AC048, 0x00000FB8}};
MEM_MAP_SUB(DDR_MP4PRM1                             ) = {{0x014AD000, 0x00001000}, {0x014AD000, 0x00001000}, {0x014AD000, 0x00001000}};
MEM_MAP_SUB(DDR_SWWORKBUFF1                         ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SUBSETSPS1                          ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SVBB2                               ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SCEB0                               ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_VBB2                                ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_VDB2                                ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_PARAM2                              ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_NONVCLPRM2                          ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SLHPRM2                             ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SEIMSG2                             ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_DPBINFOPRM2                         ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_RPLPRM2                             ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_QMTRXPRM2                           ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_DECINFOPRM2                         ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_ACODECPRM2                          ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_MKVPRM2                             ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_MP4PRM2                             ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SWWORKBUFF2                         ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_SUBSETSPS2                          ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SW_DECODER                          ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_COLPIC0                             ) = {{0x41800000, 0x00400000}, {0x41800000, 0x00400000}, {0x41800000, 0x00400000}};
MEM_MAP_SUB(DDR_COLPIC1                             ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_COLPIC2                             ) = {{0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}, {0x014AE000, 0x00000000}};
MEM_MAP_SUB(DDR_VEB0                                ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_VEBPRE0                             ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_ENCCOLPIC0                          ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_ENCPARAM0                           ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_ENCDPB0                             ) = {{0x014B28C0, 0x00000000}};
MEM_MAP_SUB(DDR_ENCDPB0_Y0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB0_Y1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB0_Y2                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB0_C0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB0_C1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB0_C2                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_VEB1                                ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_VEBPRE1                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCCOLPIC1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCPARAM1                           ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB1                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB1_Y0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB1_Y1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB1_Y2                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB1_C0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB1_C1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCDPB1_C2                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_DDR_CH1                             ) = {{0x40000000, 0x08000000}};
MEM_MAP_SUB(DDR_FRAMEBUF0                           ) = {{0x00000000, 0x01800000}, {0x00C00000, 0x00C00000}, {0x00000000, 0x01800000}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y0                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x00C00000, 0x00200000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y1                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01000000, 0x00200000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y2                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01200000, 0x00200000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y3                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01600000, 0x00200000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y4                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y5                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y6                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y7                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y8                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y9                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y10                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y11                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y12                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y13                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y14                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y15                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y16                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y17                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y18                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_Y19                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C0                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x00E00000, 0x00100000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C1                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x00F00000, 0x00100000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C2                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01400000, 0x00100000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C3                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01500000, 0x00100000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C4                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C5                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C6                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C7                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C8                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C9                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C10                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C11                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C12                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C13                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C14                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C15                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C16                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C17                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C18                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF0_C19                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FM_STILL0_Y                         ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FM_STILL0_C                         ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_BDJ_WORK                            ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_DV0                                 ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1                           ) = {{0x01800000, 0x00000000}, {0x01A00000, 0x00000000}, {0x01800000, 0x00000000}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y0                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01A00000, 0x00000000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y1                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01A00000, 0x00000000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y2                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01A00000, 0x00000000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y3                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01A00000, 0x00000000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y4                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y5                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y6                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y7                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y8                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y9                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y10                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y11                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y12                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y13                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y14                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y15                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y16                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y17                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y18                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_Y19                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C0                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01A00000, 0x00000000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C1                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01A00000, 0x00000000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C2                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01A00000, 0x00000000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C3                        ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01A00000, 0x00000000}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C4                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C5                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C6                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C7                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C8                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C9                        ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C10                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C11                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C12                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C13                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C14                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C15                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C16                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C17                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C18                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_FRAMEBUF1_C19                       ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_AIOF                                ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_DV1                                 ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SNIP_Y                              ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_SNIP_C                              ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ME0                                 ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0                             ) = {{0x01800000, 0x00000000}};
MEM_MAP_SUB(DDR_ENCBUF0_Y0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_Y1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_Y2                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_Y3                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_Y4                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_Y5                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_Y6                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_C0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_C1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_C2                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_C3                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_C4                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_C5                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF0_C6                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ME1                                 ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1                             ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_Y0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_Y1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_Y2                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_Y3                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_Y4                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_Y5                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_Y6                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_C0                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_C1                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_C2                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_C3                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_C4                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_C5                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_ENCBUF1_C6                          ) = {{DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_JPEG_SW_DEC_WORK_0                  ) = {{DO_NOT_USE, DO_NOT_USE}, {0x00000000, 0x00800000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_DEC_OUTBUF_Y0                  ) = {{DO_NOT_USE, DO_NOT_USE}, {0x00000000, 0x00200000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_DEC_OUTBUF_C0                  ) = {{DO_NOT_USE, DO_NOT_USE}, {0x00400000, 0x00400000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_DEC_OUTBUF_Y1                  ) = {{DO_NOT_USE, DO_NOT_USE}, {0x00200000, 0x00200000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_DEC_OUTBUF_C1                  ) = {{DO_NOT_USE, DO_NOT_USE}, {0x00800000, 0x00400000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_TRANS_BUF_Y0                   ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01200000, 0x00200000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_TRANS_BUF_C0                   ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01400000, 0x00200000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_LANCZOS_BUF                    ) = {{DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}, {DO_NOT_USE, DO_NOT_USE}};
MEM_MAP_SUB(DDR_JPEG_HW_DEC_RESULT_Y                ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01800000, 0x00200000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_HW_DEC_RESULT_C                ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01600000, 0x00100000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_HW_DEC_RESULT0                 ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01200000, 0x00400000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(DDR_JPEG_HW_DEC_RESULT1                 ) = {{DO_NOT_USE, DO_NOT_USE}, {0x01200000, 0x00400000}, {0x01A00000, 0x00000000}};
MEM_MAP_SUB(NOT_USED                                ) = {{DO_NOT_USE, DO_NOT_USE}};


#endif

